/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer;

import filenet.vw.api.VWQueueDefinition;

public class VWSIMAnimatorQueue {
    private String m_name = null;
    private VWQueueDefinition m_queueDef = null;
    private int m_completedCount = 0;
    private int m_activeCount = 0;
    private double m_cost = 0.0;
    private double m_averageCost = 0.0;
    private int m_overdueCount = 0;

    public VWSIMAnimatorQueue(VWQueueDefinition queueDef) {
        this.m_queueDef = queueDef;
        if (queueDef != null) {
            this.m_name = queueDef.getName();
        }
    }

    public VWSIMAnimatorQueue(String name) {
        this.m_name = name;
    }

    public VWQueueDefinition getQueueDefinition() {
        return this.m_queueDef;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        String str = this.getName();
        if (str != null) {
            return str;
        }
        return new String("");
    }

    public synchronized int getCompletedCount() {
        return this.m_completedCount;
    }

    public synchronized int getActiveCount() {
        return this.m_activeCount;
    }

    public synchronized double getCost() {
        return this.m_cost;
    }

    public synchronized double getAverageCost() {
        return this.m_averageCost;
    }

    public synchronized int getOverdueCount() {
        return this.m_overdueCount;
    }

    public synchronized void setCompletedCount(int count) {
        this.m_completedCount = count;
    }

    public synchronized void setActiveCount(int count) {
        this.m_activeCount = count;
    }

    public synchronized void setCost(double cost) {
        this.m_cost = cost;
    }

    public synchronized void setAverageCost(double cost) {
        this.m_averageCost = cost;
    }

    public synchronized void setOverdueCount(int count) {
        this.m_overdueCount = count;
    }

    public synchronized void clearStatistics() {
        this.m_activeCount = 0;
        this.m_completedCount = 0;
        this.m_overdueCount = 0;
        this.m_cost = 0.0;
        this.m_averageCost = 0.0;
    }

    void releaseResources() {
        this.m_name = null;
        this.m_queueDef = null;
    }
}

